unit Dbbtn;

interface

uses
{$ifdef WIN32}
  ComCtrls, CommCtrl,
{$endif}
  WinTypes, WinProcs, Messages, SysUtils, Classes,
  Graphics, Controls, StdCtrls, DB, DbTables, Buttons;

type
  TPDBBitBtn = class(TBitBtn)
  private
    fDataLink: TFieldDataLink;
    FReverseLogic: Boolean;
    function GetDataField: string;
    function GetDataSource: TDataSource;
    procedure SetDataField(const Field: string);
    procedure SetDataSource(DataSource: TDataSource);
    procedure DataChange(Sender: TObject);
    procedure Notification(Component: TComponent; Operation: TOperation);
        override;
  {$ifndef VER80}
    procedure CmGetDataLink(var Msg: TMessage); message Cm_GetDataLink;
  {$endif}
    procedure SetReverseLogic(Value: boolean);
  public
    constructor Create(Owner: TComponent); override;
    destructor Destroy; override;
  published
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property ReverseLogic: Boolean read FReverseLogic write SetReverseLogic;
  end;

procedure Register;

implementation

constructor TPDBBitBtn.Create(Owner: TComponent);
begin
  inherited Create(Owner);
  fDataLink := TFieldDataLink.Create;
  fDataLink.OnDataChange := DataChange;
  fDataLink.Control := Self;
  FReverseLogic := True;
end;

destructor TPDBBitBtn.Destroy;
begin
  fDataLink.Free;
  inherited Destroy;
end;

{ Refresh the link when ReverseLogic is changed }
procedure TPDBBitBtn.SetReverseLogic(Value: boolean);
begin
   if Value <> FReverseLogic then begin
      FReverseLogic := Value;
      DataChange(Self);
   end;
end;

{ Return the name of the linked database field. }
function TPDBBitBtn.GetDataField: string;
begin
  Result := fDataLink.FieldName
end;

{ Return a reference to the data source, or nil. }
function TPDBBitBtn.GetDataSource: TDataSource;
begin
  Result := fDataLink.DataSource
end;

{ Change the database field name. }
procedure TPDBBitBtn.SetDataField(const Field: string);
begin
  fDataLink.FieldName := Field
end;

{ Change the data source. In Delphi 2.0, request notification if
  the DataSource component is removed from the form. }
procedure TPDBBitBtn.SetDataSource(DataSource: TDataSource);
begin
  fDataLink.DataSource := DataSource;
{$ifndef VER80}
  { Notify the TPDBBitBtn component if the DataSource object is removed. }
  if DataSource <> nil then
    DataSource.FreeNotification(Self);
{$endif}
end;

{ If the DataSource component is removed from the form, then clear the
  DataSource pointer in the data link. }
procedure TPDBBitBtn.Notification(Component: TComponent; Operation: TOperation);
begin
  inherited Notification(Component, Operation);
  if (fDataLink <> nil) and
     (Component = DataSource) and
     (Operation = opRemove)
  then
    DataSource := nil
end;

{ The record changed, so update the Enabled to match. }
procedure TPDBBitBtn.DataChange(Sender: TObject);
begin
  if fDataLink.Field = nil then
    { If there is no field, then enable the button. }
{    Enabled := Enabled}
  else if FReverseLogic then
       { reverse logic }
       if FDataLink.Field.DisplayText = 'True' then
          Enabled := False
       else if FDataLink.Field.DisplayText = 'False' then
          Enabled := True
          else Enabled := FDataLink.Field.DisplayText = ''
      { normal logic }
      else if FDataLink.Field.DisplayText = 'True' then
          Enabled := True
       else if FDataLink.Field.DisplayText = 'False' then
          Enabled := False
          else Enabled := FDataLink.Field.DisplayText <> ''
end;

{$ifndef VER80}
{ In Delphi 2.0, a data aware control must respond to
  the Cm_GetDataLink message by returning its
  data link reference. }
procedure TPDBBitBtn.CmGetDataLink(var Msg: TMessage);
begin
  Msg.Result := LongInt(fDataLink);
end;
{$endif}

procedure Register;
begin
  RegisterComponents('Data Controls', [TPDBBitBtn]);
end;

end.
